/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ProjectileAP
extends AP6 {
    static final String[][] text = new String[][]{{"de", "Schiefer Wurf", "Zur\u00fcck", "Start", "Pause", "Weiter", "Zeitlupe", "Ausgangsh\u00f6he:", "Anfangsgeschwindigkeit:", "Winkel:", "Masse:", "Fallbeschleunigung:", "Position", "Geschwindigkeit", "Beschleunigung", "Kraft", "Energie", "(in m)", "(waagrecht)", "(senkrecht)", "Wurfweite:", "Maximale H\u00f6he:", "Dauer:", "Geschwindigkeitskomponenten:", "Geschwindigkeitsbetrag:", "Kinetische Energie:", "Potentielle Energie:", "Gesamtenergie:", ""}, {"en", "Projectile Motion", "Reset", "Start", "Pause", "Resume", "Slow motion", "Initial height:", "Initial speed:", "Angle of inclination:", "Mass:", "Gravitational acceleration:", "Position", "Velocity", "Acceleration", "Force", "Energy", "(in m)", "(horizontal)", "(vertical)", "Horizontal distance:", "Maximum height:", "Time:", "Components of velocity:", "Magnitude of velocity:", "Kinetic energy:", "Potential energy:", "Total energy:", ""}};
    private int[] gaps = new int[]{5, 3, 5, 5, 3, 3, 3, 3, 5, 0, 0, 0, 5, 5, 0, 5};
    final int width = 720;
    final int height = 420;
    final int width0 = 440;
    Font fC;
    FontMetrics fmH;
    FontMetrics fmC;
    CanvasAP cv;
    Panel6 pan;
    ResetButton bReset;
    StartButton bStart;
    JTextField tfH;
    JTextField tfV;
    JTextField tfAlpha;
    JTextField tfM;
    JTextField tfG;
    JCheckBox cbSlow;
    JRadioButton rbS;
    JRadioButton rbV;
    JRadioButton rbA;
    JRadioButton rbF;
    JRadioButton rbE;
    Color bgCanvas;
    Color bgPanel;
    Color colorPosition;
    Color colorVelocity;
    Color colorAcceleration;
    Color colorForce;
    Color colorButton1;
    Color colorButton2;
    Color colorGround;
    Color colorAngle;
    String coauthor;
    String text01;
    String text02;
    String text03;
    String text04;
    String text05;
    String text06;
    String text07;
    String text08;
    String text09;
    String text10;
    String text11;
    String text12;
    String text13;
    String text14;
    String text15;
    String text16;
    String text17;
    String text18;
    String text19;
    String text20;
    String text21;
    String text22;
    String text23;
    String text24;
    String text25;
    String text26;
    double t;
    double g;
    double h0;
    double v0;
    double v0x;
    double v0y;
    double alpha0;
    double m;
    double x;
    double y;
    double tW;
    double w;
    double hMax;
    double vyMax;
    double e;
    double x0;
    double y0;
    final int uU = 50;
    final int vU = 270;
    double PIX;
    boolean on;
    boolean slow;
    int nrSize;
    int pos1;
    int pos2;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(720, 420);
    }

    @Override
    protected void initAttributes() {
        this.fC = new Font("Courier", 1, 16);
        this.fmC = this.getFontMetrics(this.fC);
        this.h0 = 5.0;
        this.v0 = 5.0;
        this.alpha0 = 0.7853981633974483;
        this.m = 1.0;
        this.g = 9.81;
        this.calculation();
        this.pos1 = 340;
        this.pos2 = 360;
        this.slow = false;
        this.on = false;
        this.nrSize = 1;
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.bgPanel = this.getColor(Color.green, "bgPanel");
        this.colorPosition = this.getColor(Color.red, "colorPosition");
        this.colorVelocity = this.getColor(Color.magenta, "colorVelocity");
        this.colorAcceleration = this.getColor(Color.blue, "colorAcceleration");
        this.colorForce = this.getColor(new Color(0, 128, 32), "colorForce");
        this.colorButton1 = this.getColor(Color.cyan, "colorButton1");
        this.colorButton2 = this.getColor(Color.yellow, "colorButton2");
        this.colorGround = this.getColor(Color.orange, "colorGround");
        this.colorAngle = this.getColor(Color.cyan, "colorAngle");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.text02 = this.getText(t[3], "text02");
        this.text03 = this.getText(t[4], "text03");
        this.text04 = this.getText(t[5], "text04");
        this.text05 = this.getText(t[6], "text05");
        this.text06 = this.getText(t[7], "text06");
        this.text07 = this.getText(t[8], "text07");
        this.text08 = this.getText(t[9], "text08");
        this.text09 = this.getText(t[10], "text09");
        this.text10 = this.getText(t[11], "text10");
        this.text11 = this.getText(t[12], "text11");
        this.text12 = this.getText(t[13], "text12");
        this.text13 = this.getText(t[14], "text13");
        this.text14 = this.getText(t[15], "text14");
        this.text15 = this.getText(t[16], "text15");
        this.text16 = this.getText(t[17], "text16");
        this.text17 = this.getText(t[18], "text17");
        this.text18 = this.getText(t[19], "text18");
        this.text19 = this.getText(t[20], "text19");
        this.text20 = this.getText(t[21], "text20");
        this.text21 = this.getText(t[22], "text21");
        this.text22 = this.getText(t[23], "text22");
        this.text23 = this.getText(t[24], "text23");
        this.text24 = this.getText(t[25], "text24");
        this.text25 = this.getText(t[26], "text25");
        this.text26 = this.getText(t[27], "text26");
        this.coauthor = this.getText(t[28], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 440, 420);
        this.add(this.cv);
    }

    @Override
    protected void initPanel() {
        this.pan = new Panel6(this, this.bgPanel, 3, this.gaps);
        this.pan.setBounds(440, 0, 280, 420);
        this.bReset = new ResetButton(this.text01);
        this.pan.add(this.bReset, this.colorButton1, Color.black);
        this.bStart = new StartButton(this.text02, this.text03, this.text04);
        this.pan.add(this.bStart, this.colorButton2, Color.black);
        this.cbSlow = new JCheckBox(this.text05);
        this.pan.add(this.cbSlow, this.bgPanel, Color.black);
        this.tfH = this.pan.newInputField(this.text06, this.meter, this.bgPanel, Color.black, 2);
        this.tfH.setText(this.toString(this.h0, 3));
        this.tfV = this.pan.newInputField(this.text07, this.meterPerSecond, this.bgPanel, Color.black, 2);
        this.tfV.setText(this.toString(this.v0, 3));
        this.tfAlpha = this.pan.newInputField(this.text08, this.degree, this.bgPanel, Color.black, 2);
        this.tfAlpha.setText(this.toString(this.alpha0 / (Math.PI / 180), 3));
        this.tfM = this.pan.newInputField(this.text09, this.kilogram, this.bgPanel, Color.black, 2);
        this.tfM.setText(this.toString(this.m, 3));
        this.tfG = this.pan.newInputField(this.text10, this.meterPerSecond2, this.bgPanel, Color.black, 2);
        this.tfG.setText(this.toString(this.g, 3));
        ButtonGroup bg = new ButtonGroup();
        this.rbS = this.newRadioButton(this.text11, this.colorPosition, bg);
        this.rbS.setSelected(true);
        this.rbV = this.newRadioButton(this.text12, this.colorVelocity, bg);
        this.rbA = this.newRadioButton(this.text13, this.colorAcceleration, bg);
        this.rbF = this.newRadioButton(this.text14, this.colorForce, bg);
        this.rbE = this.newRadioButton(this.text15, Color.black, bg);
        this.pan.add(2000);
        this.pan.add(this.coauthor);
        this.add(this.pan);
        this.bReset.addActionListener(this);
        this.bStart.addActionListener(this);
        this.cbSlow.addActionListener(this);
    }

    @Override
    public void run() {
        long t0 = System.currentTimeMillis();
        while (this.thr == Thread.currentThread()) {
            this.cv.repaint();
            try {
                Thread.sleep(this.on ? 50L : 100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            long t1 = System.currentTimeMillis();
            if (this.on) {
                double dt = (double)(t1 - t0) / 1000.0;
                if (this.slow) {
                    dt /= 10.0;
                }
                this.t += dt;
                if (this.t > this.tW) {
                    this.t = this.tW;
                }
            }
            t0 = t1;
        }
    }

    JRadioButton newRadioButton(String text, Color c, ButtonGroup bg) {
        JRadioButton rb = new JRadioButton(text, true);
        bg.add(rb);
        this.pan.add(rb, this.bgPanel, c);
        rb.addActionListener(this);
        return rb;
    }

    int getStep1() {
        double limit = 5.0;
        int step1 = 1;
        while (!(this.PIX >= limit)) {
            limit /= 10.0;
            step1 *= 10;
        }
        return step1;
    }

    int getStep2() {
        double limit = 50.0;
        int step1 = 1;
        while (!(this.PIX >= limit)) {
            limit /= 2.0;
            step1 *= 2;
            if (this.PIX >= limit) {
                return step1;
            }
            limit /= 2.5;
            step1 = 5 * step1 / 2;
            if (this.PIX >= limit) {
                return step1;
            }
            limit /= 2.0;
            step1 *= 2;
        }
        return step1;
    }

    double getFactor(double maxReal, double maxPixel) {
        double q = maxPixel / maxReal;
        double f = maxPixel;
        while (!((f /= 2.0) < q || (f /= 2.5) < q || (f /= 2.0) < q)) {
        }
        return f;
    }

    void calculation() {
        this.v0x = this.v0 * Math.cos(this.alpha0);
        this.v0y = this.v0 * Math.sin(this.alpha0);
        if (Math.cos(this.alpha0) < 1.0E-10) {
            this.v0x = 0.0;
        }
        this.tW = (this.v0y + Math.sqrt(this.v0y * this.v0y + 2.0 * this.g * this.h0)) / this.g;
        this.w = this.v0x * this.tW;
        if (this.v0y > 0.0) {
            double t = this.v0y / this.g;
            this.hMax = this.h0 + this.v0y * t - this.g * t * t / 2.0;
        } else {
            this.hMax = this.h0;
        }
        this.vyMax = Math.abs(this.v0y - this.g * this.tW);
        this.e = this.m * this.v0 * this.v0 / 2.0 + this.m * this.g * this.h0;
        this.PIX = this.getFactor(Math.max(this.w, this.hMax), 300.0);
        if (this.PIX * this.hMax > 220.0) {
            this.PIX /= 2.0;
        }
    }

    void changeValues() {
        this.h0 = this.inputTF(this.tfH, 0.0, 100.0, 3);
        this.v0 = this.inputTF(this.tfV, 0.0, 100.0, 3);
        this.alpha0 = this.inputTF(this.tfAlpha, -90.0, 90.0, 3) * (Math.PI / 180);
        this.m = this.inputTF(this.tfM, 0.1, 10.0, 3);
        this.g = this.inputTF(this.tfG, 1.0, 100.0, 3);
        this.calculation();
    }

    void setTF(boolean flag) {
        this.tfH.setEnabled(flag);
        this.tfV.setEnabled(flag);
        this.tfAlpha.setEnabled(flag);
        this.tfM.setEnabled(flag);
        this.tfG.setEnabled(flag);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o == this.bReset) {
            this.bStart.setState(0);
            this.setTF(true);
            this.t = 0.0;
        } else if (o == this.bStart) {
            this.bStart.setState();
            this.setTF(false);
            this.changeValues();
        } else if (o instanceof JTextField) {
            this.changeValues();
        }
        if (this.rbS.isSelected()) {
            this.nrSize = 1;
        } else if (this.rbV.isSelected()) {
            this.nrSize = 2;
        } else if (this.rbA.isSelected()) {
            this.nrSize = 3;
        } else if (this.rbF.isSelected()) {
            this.nrSize = 4;
        } else if (this.rbE.isSelected()) {
            this.nrSize = 5;
        }
        this.on = this.bStart.getState() == 1;
        this.slow = this.cbSlow.isSelected();
        if (!this.on) {
            this.cv.repaint();
        }
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, ProjectileAP.this.bgCanvas);
            ProjectileAP.this.fmH = this.getFontMetrics(this.fH);
        }

        void clock(Graphics2D gr) {
            int x = 140;
            int y = 30;
            CanvasAP.rectangle(gr, x - 60, y - 15, 120.0, 30.0, Color.gray, true);
            CanvasAP.rectangle(gr, x - 50, y - 10, 100.0, 20.0, Color.black, true);
            gr.setColor(Color.red);
            gr.setFont(ProjectileAP.this.fC);
            String s = this.frame.toString(ProjectileAP.this.t, 3) + " " + ProjectileAP.this.second;
            int w = ProjectileAP.this.fmC.stringWidth(s);
            CanvasAP.setAntiAliasing(gr, false);
            gr.drawString(s, x - w / 2, y + 5);
            CanvasAP.setAntiAliasing(gr, true);
            gr.setFont(this.fH);
        }

        void angle(Graphics2D gr, double x0, double y0, double dw) {
            double wi = Math.abs(dw);
            double w0 = dw > 0.0 ? 0.0 : Math.PI * 2 - wi;
            CanvasAP.angle(gr, x0, y0, 20.0, w0, wi, ProjectileAP.this.colorAngle);
            CanvasAP.line(gr, x0, y0, x0 + 20.0, y0);
            double x1 = x0 + 20.0 * Math.cos(dw);
            double y1 = y0 - 20.0 * Math.sin(dw);
            CanvasAP.line(gr, x0, y0, x1, y1);
        }

        void ball(Graphics2D gr) {
            ProjectileAP.this.x = ProjectileAP.this.v0x * ProjectileAP.this.t;
            ProjectileAP.this.y = ProjectileAP.this.h0 + ProjectileAP.this.v0y * ProjectileAP.this.t - ProjectileAP.this.g * ProjectileAP.this.t * ProjectileAP.this.t / 2.0;
            if (ProjectileAP.this.y < 0.0) {
                ProjectileAP.this.y = 0.0;
            }
            ProjectileAP.this.x0 = 50.0 + ProjectileAP.this.PIX * ProjectileAP.this.x;
            ProjectileAP.this.y0 = 270.0 - ProjectileAP.this.PIX * ProjectileAP.this.y;
            CanvasAP.circle(gr, ProjectileAP.this.x0, ProjectileAP.this.y0, 3.5, Color.black, true);
        }

        void orbit(Graphics2D gr) {
            gr.setColor(ProjectileAP.this.colorPosition);
            if (ProjectileAP.this.v0x < 1.0E-10) {
                CanvasAP.line(gr, 50.0, 270.0, 50.0, 270.0 - ProjectileAP.this.hMax * ProjectileAP.this.PIX);
                return;
            }
            double gH = ProjectileAP.this.g / 2.0;
            double x0 = 50.0;
            double y0 = 270.0 - ProjectileAP.this.h0 * ProjectileAP.this.PIX;
            double t = 0.0;
            while (t < ProjectileAP.this.tW) {
                double x1 = x0 + 1.0;
                double x = (x1 - 50.0) / ProjectileAP.this.PIX;
                t = x / ProjectileAP.this.v0x;
                double y = ProjectileAP.this.h0 + t * (ProjectileAP.this.v0y - gH * t);
                double y1 = 270.0 - y * ProjectileAP.this.PIX;
                CanvasAP.line(gr, x0, y0, x1, y1);
                x0 = x1;
                y0 = y1;
            }
        }

        void writeValue(Graphics gr, String beg, double val, String end, int x, int y) {
            String s = beg + ProjectileAP.this.toString2(val, 3, 1.0E-6) + end;
            gr.drawString(s, x, y);
        }

        void axes(Graphics2D gr) {
            int d;
            gr.setColor(Color.black);
            CanvasAP.arrow(gr, 40.0, 270.0, 405.0, 270.0);
            CanvasAP.arrow(gr, 50.0, 280.0, 50.0, 15.0);
            int step1 = ProjectileAP.this.getStep1();
            int step2 = ProjectileAP.this.getStep2();
            int i = 1;
            while ((double)i <= 330.0 / ProjectileAP.this.PIX) {
                double x = 50.0 + (double)i * ProjectileAP.this.PIX;
                int n = d = i % step2 == 0 ? 5 : 2;
                if (i % step1 == 0) {
                    CanvasAP.line(gr, x, 270 - d, x, 270 + d);
                }
                if (i % step2 == 0) {
                    this.alignText(gr, "" + i, this.fH, 1, (int)x, 288);
                }
                ++i;
            }
            i = 1;
            while ((double)i <= 220.0 / ProjectileAP.this.PIX) {
                double y = 270.0 - (double)i * ProjectileAP.this.PIX;
                int n = d = i % step2 == 0 ? 5 : 2;
                if (i % step1 == 0) {
                    CanvasAP.line(gr, 50 - d, y, 50 + d, y);
                }
                if (i % step2 == 0) {
                    this.alignText(gr, "" + i, this.fH, 2, 43, (int)y + 4);
                }
                ++i;
            }
            this.alignText(gr, "x", this.fH, 1, 400, 288);
            this.alignText(gr, ProjectileAP.this.text16, this.fH, 1, 400, 300);
            this.alignText(gr, "y", this.fH, 1, 30, 25);
            this.alignText(gr, ProjectileAP.this.text16, this.fH, 1, 30, 40);
        }

        void drawS(Graphics2D gr) {
            CanvasAP.setAntiAliasing(gr, false);
            gr.setColor(ProjectileAP.this.colorPosition);
            gr.drawString(ProjectileAP.this.text11 + ":", 220, 25);
            this.writeValue(gr, "x = ", ProjectileAP.this.x, " " + ProjectileAP.this.meter, 240, 40);
            gr.drawString(ProjectileAP.this.text17, 320, 40);
            this.writeValue(gr, "y = ", ProjectileAP.this.y, " " + ProjectileAP.this.meter, 240, 55);
            gr.drawString(ProjectileAP.this.text18, 320, 55);
            gr.drawString(ProjectileAP.this.text19, 220, 80);
            this.writeValue(gr, "", ProjectileAP.this.w, " " + ProjectileAP.this.meter, ProjectileAP.this.pos1, 80);
            gr.drawString(ProjectileAP.this.text20, 220, 95);
            this.writeValue(gr, "", ProjectileAP.this.hMax, " " + ProjectileAP.this.meter, ProjectileAP.this.pos1, 95);
            gr.drawString(ProjectileAP.this.text21, 220, 120);
            this.writeValue(gr, "", ProjectileAP.this.tW, " " + ProjectileAP.this.second, ProjectileAP.this.pos1, 120);
            CanvasAP.setAntiAliasing(gr, true);
            CanvasAP.line(gr, ProjectileAP.this.x0, 265.0, ProjectileAP.this.x0, 275.0);
            CanvasAP.line(gr, 45.0, ProjectileAP.this.y0, 55.0, ProjectileAP.this.y0);
        }

        void drawV(Graphics2D gr) {
            double vy = ProjectileAP.this.v0y - ProjectileAP.this.g * ProjectileAP.this.t;
            double alpha = Math.atan(vy / ProjectileAP.this.v0x);
            this.angle(gr, ProjectileAP.this.x0, ProjectileAP.this.y0, alpha);
            this.orbit(gr);
            double l = ProjectileAP.this.vyMax * 10.0;
            double f = l > 120.0 ? l / 120.0 : 1.0;
            double dxPix = ProjectileAP.this.v0x * 10.0 / f;
            double dyPix = vy * 10.0 / f;
            gr.setColor(ProjectileAP.this.colorVelocity);
            CanvasAP.arrow(gr, 3.0, ProjectileAP.this.x0, ProjectileAP.this.y0, ProjectileAP.this.x0 + dxPix, ProjectileAP.this.y0 - dyPix);
            CanvasAP.arrow(gr, ProjectileAP.this.x0, ProjectileAP.this.y0, ProjectileAP.this.x0 + dxPix, ProjectileAP.this.y0);
            CanvasAP.arrow(gr, ProjectileAP.this.x0, ProjectileAP.this.y0, ProjectileAP.this.x0, ProjectileAP.this.y0 - dyPix);
            CanvasAP.setAntiAliasing(gr, false);
            String mps = " " + ProjectileAP.this.meterPerSecond;
            gr.drawString(ProjectileAP.this.text22, 220, 25);
            int w1 = ProjectileAP.this.fmH.stringWidth("v");
            int w2 = 2 * w1 + ProjectileAP.this.fmH.stringWidth("  ");
            gr.drawString("v", 240, 40);
            gr.drawString("x", 240 + w1, 45);
            this.writeValue(gr, "= ", ProjectileAP.this.v0x, mps, 240 + w2, 40);
            gr.drawString(ProjectileAP.this.text17, 330, 40);
            gr.drawString("v", 240, 55);
            gr.drawString("y", 240 + w1, 60);
            this.writeValue(gr, "= ", vy, mps, 240 + w2, 55);
            gr.drawString(ProjectileAP.this.text18, 330, 55);
            gr.drawString(ProjectileAP.this.text23, 220, 80);
            double v = Math.sqrt(ProjectileAP.this.v0x * ProjectileAP.this.v0x + vy * vy);
            this.writeValue(gr, "", v, mps, 240, 95);
            gr.drawString(ProjectileAP.this.text08, 220, 120);
            this.writeValue(gr, "", alpha / (Math.PI / 180), ProjectileAP.this.degree, 350, 120);
            gr.setColor(Color.black);
            CanvasAP.setAntiAliasing(gr, true);
            CanvasAP.line(gr, ProjectileAP.this.x0 + dxPix, ProjectileAP.this.y0, ProjectileAP.this.x0 + dxPix, ProjectileAP.this.y0 - dyPix);
            CanvasAP.line(gr, ProjectileAP.this.x0, ProjectileAP.this.y0 - dyPix, ProjectileAP.this.x0 + dxPix, ProjectileAP.this.y0 - dyPix);
        }

        void drawA(Graphics2D gr) {
            double laenge = ProjectileAP.this.g < 30.0 ? ProjectileAP.this.g * 4.0 : 120.0;
            gr.setColor(ProjectileAP.this.colorAcceleration);
            CanvasAP.arrow(gr, 3.0, ProjectileAP.this.x0, ProjectileAP.this.y0, ProjectileAP.this.x0, ProjectileAP.this.y0 + laenge);
            CanvasAP.setAntiAliasing(gr, false);
            gr.drawString(ProjectileAP.this.text13 + ":", 220, 25);
            String mps2 = " " + ProjectileAP.this.meterPerSecond2;
            this.writeValue(gr, "", ProjectileAP.this.g, mps2, 330, 25);
            CanvasAP.setAntiAliasing(gr, true);
        }

        void drawF(Graphics2D gr) {
            double laenge = ProjectileAP.this.g < 30.0 / ProjectileAP.this.m ? ProjectileAP.this.g * 4.0 * ProjectileAP.this.m : 120.0;
            gr.setColor(ProjectileAP.this.colorForce);
            CanvasAP.arrow(gr, 3.0, ProjectileAP.this.x0, ProjectileAP.this.y0, ProjectileAP.this.x0, ProjectileAP.this.y0 + laenge);
            CanvasAP.setAntiAliasing(gr, false);
            gr.drawString(ProjectileAP.this.text14 + ":", 220, 25);
            this.writeValue(gr, "", ProjectileAP.this.m * ProjectileAP.this.g, " " + ProjectileAP.this.newton, 330, 25);
            CanvasAP.setAntiAliasing(gr, true);
        }

        void drawE(Graphics2D gr) {
            double ePot = ProjectileAP.this.m * ProjectileAP.this.g * ProjectileAP.this.y;
            CanvasAP.setAntiAliasing(gr, false);
            String j = " " + ProjectileAP.this.joule;
            gr.setColor(ProjectileAP.this.colorVelocity);
            gr.drawString(ProjectileAP.this.text24, 220, 25);
            this.writeValue(gr, "", ProjectileAP.this.e - ePot, j, ProjectileAP.this.pos2, 25);
            gr.setColor(ProjectileAP.this.colorPosition);
            gr.drawString(ProjectileAP.this.text25, 220, 40);
            this.writeValue(gr, "", ePot, j, ProjectileAP.this.pos2, 40);
            gr.setColor(Color.black);
            gr.drawString(ProjectileAP.this.text26, 220, 65);
            this.writeValue(gr, "", ProjectileAP.this.e, j, ProjectileAP.this.pos2, 65);
            CanvasAP.setAntiAliasing(gr, true);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            g.setClip(2, 2, 436, 416);
            Graphics2D g2 = (Graphics2D)g;
            CanvasAP.setAntiAliasing(g2, true);
            int vv = 273;
            CanvasAP.rectangle(g2, 0.0, vv, 440.0, 420 - vv, ProjectileAP.this.colorGround, true);
            g.setFont(this.fH);
            this.ball(g2);
            this.axes(g2);
            this.clock(g2);
            if (ProjectileAP.this.nrSize != 2) {
                this.orbit(g2);
            }
            switch (ProjectileAP.this.nrSize) {
                case 1: {
                    this.drawS(g2);
                    break;
                }
                case 2: {
                    this.drawV(g2);
                    break;
                }
                case 3: {
                    this.drawA(g2);
                    break;
                }
                case 4: {
                    this.drawF(g2);
                    break;
                }
                case 5: {
                    this.drawE(g2);
                }
            }
        }
    }
}

